/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.SimpleBehaviour;

public abstract class TickerBehaviour
extends SimpleBehaviour {
    private long wakeupTime;
    private long period;
    private boolean finished;
    private int tickCount = 0;

    public TickerBehaviour(Agent a, long period) {
        super(a);
        if (period <= 0L) {
            throw new IllegalArgumentException("Period must be greater than 0");
        }
        this.period = period;
    }

    public void onStart() {
        this.wakeupTime = System.currentTimeMillis() + this.period;
    }

    public final void action() {
        if (!this.finished) {
            long blockTime = this.wakeupTime - System.currentTimeMillis();
            if (blockTime <= 0L) {
                ++this.tickCount;
                this.onTick();
                this.wakeupTime = System.currentTimeMillis() + this.period;
                blockTime = this.period;
            }
            if (this.myAgent != null) {
                this.block(blockTime);
            }
        }
    }

    public final boolean done() {
        return this.finished;
    }

    protected abstract void onTick();

    public void reset(long period) {
        this.reset();
        if (period <= 0L) {
            throw new IllegalArgumentException("Period must be greater than 0");
        }
        this.period = period;
    }

    public void reset() {
        super.reset();
        this.finished = false;
        this.tickCount = 0;
    }

    public void stop() {
        this.finished = true;
    }

    public final int getTickCount() {
        return this.tickCount;
    }

    private void setTickCount(int tc) {
        this.tickCount = tc;
    }

    private void setPeriod(long p) {
        this.period = p;
    }

    private long getPeriod() {
        return this.period;
    }

    private void setWakeupTime(long wt) {
        this.wakeupTime = wt;
    }

    private long getWakeupTime() {
        return this.wakeupTime;
    }
}

